#include "TPM2ErrorDecode.h"

//1.1.2	Format-Zero Errors
void formatZeroErrors()
{
	int i = 0;
	for( i = 0; i < 128; i++ ) {
		ErrorText0[i] = AllocateZeroPool(512);
	}
	for( i = 0; i < 128; i++ ) {
		ZeroMem ( ErrorText0[i],  sizeof(ErrorText0[i]) );
	}
	for( i = 0; i < 128; i++ ) {
		StrCpy(ErrorText0[i], L"UNKOWN ERROR");
	}
	StrCpy(ErrorText0[0], L"TPM_RC_INITIALIZE: TPM not initialized");
	StrCpy(ErrorText0[1], L"TPM_RC_FAILURE: Commands are not being accepted because of a TPM failure");
	StrCpy(ErrorText0[3], L"TPM_RC_SEQUENCE: Improper use of a sequence handle ");
	StrCpy(ErrorText0[11], L"TPM_RC_PRIVATE: ");
	StrCpy(ErrorText0[25], L"TPM_RC_HMAC: ");
	StrCpy(ErrorText0[32], L"TPM_RC_DISABLED: ");
	StrCpy(ErrorText0[33], L"TPM_RC_EXCLUSIVE: Command failed because audit sequence required exclusivity");
	StrCpy(ErrorText0[35], L"TPM_RC_ECC_CURVE: Unsupported curve");
	StrCpy(ErrorText0[36], L"TPM_RC_AUTH_TYPE: Authorization handle is not correct for command");
	StrCpy(ErrorText0[37], L"TPM_RC_AUTH_MISSING: Command requires an authorization session for handle and it is not present.");
	StrCpy(ErrorText0[38], L"TPM_RC_POLICY: Policy Failure In Math Operation or an invalid authPolicy value");
	StrCpy(ErrorText0[39], L"TPM_RC_PCR: PCR check fail");
	StrCpy(ErrorText0[40], L"TPM_RC_PCR_CHANGED: PCR have changed since checked.");
	StrCpy(ErrorText0[44], L"TPM_RC_ECC_POINT: Point is not on the required curve.");
	StrCpy(ErrorText0[45], L"TPM_RC_UPGRADE:  The TPM is in field upgrade mode - or for TPM2_FieldUpgradeData(): the TPM is not in field upgrade mode");
	StrCpy(ErrorText0[46], L"TPM_RC_TOO_MANY_CONTEXTS: Context ID counter is at maximum.");
	StrCpy(ErrorText0[47], L"TPM_RC_AUTH_UNAVAILABLE: authValue or authPolicy is not available for selected entity.");
	StrCpy(ErrorText0[48], L"TPM_RC_REBOOT: A _TPM_Init and Startup(CLEAR) is required before the TPM can resume operation.");
	StrCpy(ErrorText0[49], L"TPM_RC_UNBALANCED: The protection algorithms (hash and symmetric) are not reasonably balanced. The digest size of the hash must be larger than the key size of the symmetric algorithm.");
	StrCpy(ErrorText0[66], L"TPM_RC_COMMAND_SIZE: Command commandSize value is inconsistent with contents of the command buffer; either the size is not the same as the octets loaded by the hardware interface layer or the value is not large enough to hold a command header");
	StrCpy(ErrorText0[67], L"TPM_RC_COMMAND_CODE: Command code not supported");
	StrCpy(ErrorText0[68], L"TPM_RC_AUTHSIZE: The value of authorzationSize is out of range or the number of octets in the authorization area is greater than required");
	StrCpy(ErrorText0[69], L"TPM_RC_AUTH_CONTEXT: Use of an authorization session with a context command");
	StrCpy(ErrorText0[70], L"TPM_RC_NV_RANGE: NV offset+size is out of range.");
	StrCpy(ErrorText0[71], L"TPM_RC_NV_SIZE: Requested allocation size is larger than allowed.");
	StrCpy(ErrorText0[72], L"TPM_RC_NV_LOCKED: NV access locked.");
	StrCpy(ErrorText0[73], L"TPM_RC_NV_AUTHORIZATION: NV access authorization fails in command actions (this failure does not affect lockout.action)");
	StrCpy(ErrorText0[74], L"TPM_RC_NV_UNINITIALIZED: An NV Index is used before being initialized or the state saved by TPM2_Shutdown(STATE) could not be restored");
	StrCpy(ErrorText0[75], L"TPM_RC_NV_SPACE: Insufficient space for NV allocation");
	StrCpy(ErrorText0[76], L"TPM_RC_NV_DEFINED: NV index or persistent object already defined");
	StrCpy(ErrorText0[80], L"TPM_RC_BAD_CONTEXT: Context in TPM2_ContextLoad() is not valid");
	StrCpy(ErrorText0[81], L"TPM_RC_CPHASH: cpHash value already set or not correct for use");
	StrCpy(ErrorText0[82], L"TPM_RC_PARENT: Handle for parent is not a valid parent");
	StrCpy(ErrorText0[83], L"TPM_RC_NEEDS_TEST: Some function needs testing.");
	StrCpy(ErrorText0[84], L"TPM_RC_NO_RESULT: An internal function cannot process the request due to an unspecified problem. ");
	StrCpy(ErrorText0[85], L"TPM_RC_SENSITIVE: The sensitive area did not unmarshal correctly after decryption");
	StrCpy(ErrorText0[127], L"RC_MAX_FM0: Largest format 0 code that is not a warning");

	return;
}


//1.1.3	Format-One Errors
void formatOneErrors()
{
	int i = 0;
	for( i = 0; i < 39; i++ ) {
		ErrorText1[i] = AllocateZeroPool(512);
	}
	for( i = 0; i < 39; i++ ) {
		ZeroMem ( ErrorText1[i],  sizeof(ErrorText1[i]) );
	}
	for( i = 0; i < 39; i++ ) {
		StrCpy(ErrorText1[i], L"UNKOWN ERROR");
	}
	StrCpy(ErrorText1[1], L"TPM_RC_ASYMMETRIC: Asymmetric algorithm not supported or not correct");
	StrCpy(ErrorText1[2], L"TPM_RC_ATTRIBUTES: Inconsistent attributes");
	StrCpy(ErrorText1[3], L"TPM_RC_HASH: Hash algorithm not supported or not appropriate ");
	StrCpy(ErrorText1[4], L"TPM_RC_VALUE: Value is out of range or is not correct for the context");
	StrCpy(ErrorText1[5], L"TPM_RC_HIERARCHY: Hierarchy is not enabled or is not correct for the use");
	StrCpy(ErrorText1[7], L"TPM_RC_KEY_SIZE: Key size is not supported");
	StrCpy(ErrorText1[8], L"TPM_RC_MGF: Mask generation function not supported");
	StrCpy(ErrorText1[9], L"TPM_RC_MODE: Mode of operation not supported");
	StrCpy(ErrorText1[10], L"TPM_RC_TYPE: The type of the value is not appropriate for the use");
	StrCpy(ErrorText1[11], L"TPM_RC_HANDLE: The handle is not correct for the use");
	StrCpy(ErrorText1[12], L"TPM_RC_KDF: Unsupported key derivation function or function not appropriate for use");
	StrCpy(ErrorText1[13], L"TPM_RC_RANGE: Value was out of allowed range.");
	StrCpy(ErrorText1[14], L"TPM_RC_AUTH_FAIL: The authorization HMAC check failed and DA counter incremented ");
	StrCpy(ErrorText1[15], L"TPM_RC_NONCE: Invalid nonce size");
	StrCpy(ErrorText1[16], L"TPM_RC_PP: Authorization requires assertion of PP");
	StrCpy(ErrorText1[18], L"TPM_RC_SCHEME: Unsupported or incompatible scheme");
	StrCpy(ErrorText1[21], L"TPM_RC_SIZE: Structure is the wrong size");
	StrCpy(ErrorText1[22], L"TPM_RC_SYMMETRIC: Unsupported symmetric algorithm or key size, or not appropriate for instance");
	StrCpy(ErrorText1[23], L"TPM_RC_TAG: Incorrect structure tag");
	StrCpy(ErrorText1[24], L"TPM_RC_SELECTOR: Union selector is incorrect");
	StrCpy(ErrorText1[26], L"TPM_RC_INSUFFICIENT: The TPM was unable to unmarshal a value because there were not enough octets in the input buffer ");
	StrCpy(ErrorText1[27], L"TPM_RC_SIGNATURE: The signature is not valid");
	StrCpy(ErrorText1[28], L"TPM_RC_KEY: Key fields are not compatible with each other");
	StrCpy(ErrorText1[29], L"TPM_RC_POLICY_FAIL: A policy check failed");
	StrCpy(ErrorText1[31], L"TPM_RC_INTEGRITY: Integrity check failed ");
	StrCpy(ErrorText1[32], L"TPM_RC_TICKET: Invalid ticket ");
	StrCpy(ErrorText1[33], L"TPM_RC_RESERVED_BITS: Reserved bits not set to zero as required");
	StrCpy(ErrorText1[34], L"TPM_RC_BAD_AUTH: Authorization failure without DA implications");
	StrCpy(ErrorText1[35], L"TPM_RC_EXPIRED: The policy has expired");
	StrCpy(ErrorText1[36], L"TPM_RC_POLICY_CC: The commandCode in the policy is not the commandCode of the command");
	StrCpy(ErrorText1[37], L"TPM_RC_BINDING: ");
	StrCpy(ErrorText1[38], L"TPM_RC_CURVE: Curve not supported");

	return;
}

//1.1.4	Warnings
void warnings()
{
	int i = 0;
	for( i = 0; i < 128; i++ ) {
		WarnText[i] = AllocateZeroPool(512);
	}
	for( i = 0; i < 128; i++ ) {
		ZeroMem ( WarnText[i],  sizeof(WarnText[i]) );
	}
	for( i = 0; i < 128; i++ ) {
		StrCpy(WarnText[i], L"UNKOWN ERROR");
	}
	StrCpy(WarnText[1], L"TPM_RC_CONTEXT_GAP: gap for context ID is too large");
	StrCpy(WarnText[2], L"TPM_RC_OBJECT_MEMORY: out of memory for object contexts");
	StrCpy(WarnText[3], L"TPM_RC_SESSION_MEMORY: out of memory for session contexts");
	StrCpy(WarnText[4], L"TPM_RC_MEMORY: out of shared object/session memory or need space for internal operations");
	StrCpy(WarnText[5], L"TPM_RC_SESSION_HANDLES: out of session handles  a session must be flushed before a new session may be created");
	StrCpy(WarnText[6], L"TPM_RC_OBJECT_HANDLES: out of object handles  the handle space for objects is depleted and a reboot is required");
	StrCpy(WarnText[7], L"TPM_RC_LOCALITY: bad locality");
	StrCpy(WarnText[8], L"TPM_RC_YIELDED: TPM has suspended operation on the command; forward progress was made and the command may be retried. See Part 1, Multi-tasking.");
	StrCpy(WarnText[9], L"TPM_RC_CANCELLED: the command was canceled");
	StrCpy(WarnText[10], L"TPM_RC_TESTING: TPM is performing self-tests");
	StrCpy(WarnText[16], L"TPM_RC_REFERENCE_H0: the 1st handle in the handle area references a transient object or session that is not loaded");
	StrCpy(WarnText[17], L"TPM_RC_REFERENCE_H1: the 2nd handle in the handle area references a transient object or session that is not loaded");
	StrCpy(WarnText[18], L"TPM_RC_REFERENCE_H2: the 3rd handle in the handle area references a transient object or session that is not loaded");
	StrCpy(WarnText[19], L"TPM_RC_REFERENCE_H3: the 4th handle in the handle area references a transient object or session that is not loaded");
	StrCpy(WarnText[20], L"TPM_RC_REFERENCE_H4: the 5th handle in the handle area references a transient object or session that is not loaded");
	StrCpy(WarnText[21], L"TPM_RC_REFERENCE_H5: the 6th handle in the handle area references a transient object or session that is not loaded");
	StrCpy(WarnText[22], L"TPM_RC_REFERENCE_H6: the 7th handle in the handle area references a transient object or session that is not loaded");
	StrCpy(WarnText[24], L"TPM_RC_REFERENCE_S0: the 1st authorization session handle references a session that is not loaded");
	StrCpy(WarnText[25], L"TPM_RC_REFERENCE_S1: the 2nd authorization session handle references a session that is not loaded");
	StrCpy(WarnText[26], L"TPM_RC_REFERENCE_S2: the 3rd authorization session handle references a session that is not loaded");
	StrCpy(WarnText[27], L"TPM_RC_REFERENCE_S3: the 4th authorization session handle references a session that is not loaded");
	StrCpy(WarnText[28], L"TPM_RC_REFERENCE_S4: the 5th session handle references a session that is not loaded");
	StrCpy(WarnText[29], L"TPM_RC_REFERENCE_S5: the 6th session handle references a session that is not loaded");
	StrCpy(WarnText[30], L"TPM_RC_REFERENCE_S6: the 7th authorization session handle references a session that is not loaded");
	StrCpy(WarnText[32], L"TPM_RC_NV_RATE: the TPM is rate-limiting accesses to prevent wear out of NV");
	StrCpy(WarnText[33], L"TPM_RC_LOCKOUT: TPM is in DA lockout mode - authorizations subject to DA protection are not allowed at this time ");
	StrCpy(WarnText[34], L"TPM_RC_RETRY: the TPM was not able to start the command");
	StrCpy(WarnText[35], L"TPM_RC_NV_UNAVAILABLE: the command may require writing of NV and NV is not currently accessible");
	StrCpy(WarnText[127], L"TPM_RC_NOT_USED: this value is reserved ");

	return;
}


void decodeTpm20ErrorCode(UINT32 TPM2ReturnCode)
{
	formatZeroErrors();
	formatOneErrors();
	warnings();
	if ( TPM2ReturnCode == 0x0 || TPM2ReturnCode == 0x10000 ) {
		Print(L"Success");
		return; 
	} else if ( TPM2ReturnCode == 0x30 ) {
		Print(L"BAD TAG\n");
		return;
	} else if ( (TPM2ReturnCode & BIT_7) == 0 ) {
		//then use FORMAT-ZERO as follows:
		UINT32 errorCode = TPM2ReturnCode & 0x0000007F;
		if ( (TPM2ReturnCode & BIT_8) == 0 ) {
			Print(L"Return Code 0x%x is a TPM1.2 Error Code\n", TPM2ReturnCode);
		}
		if ( (TPM2ReturnCode & BIT_9) != 0 ) {
			Print(L"Reserved Bit 9 is set\n");
		}
		if ( (TPM2ReturnCode & BIT_11) != 0 ) {
			Print(L"Return Code 0x%x indicates WARNING  %s,TPM2ReturnCode\n", WarnText[errorCode]);
		} else if ( (TPM2ReturnCode & BIT_10) != 0 ) {
			Print(L"Return Code 0x%x indicates Vendor Defined Error\n", TPM2ReturnCode );
		} else {
			Print(L"Return Code 0x%x indicates %s\n", TPM2ReturnCode, ErrorText0[ errorCode ] );
		}
	} else {//use FORMAT-ONE as follows:
		UINT32 errorCode = TPM2ReturnCode &  0x0000003F;
		UINT32 paramNumber = (TPM2ReturnCode & 0x00000700) / 0x100;
		CHAR16 errorLocation[10];
		if ( (TPM2ReturnCode & BIT_6) != 0 ) {
			StrCpy(errorLocation, L"Parameter");
		} else if ( (TPM2ReturnCode & BIT_11) != 0 ) {
			StrCpy(errorLocation, L"Session");
		} else {
			StrCpy(errorLocation, L"Handle");
		}
		
		if ( paramNumber == 0 ) {
			Print(L"Return Code 0x%x indicates the command has the following error: \n  %s \n", TPM2ReturnCode, ErrorText1[errorCode] );
		} else { 
			Print(L"Return Code 0x%x indicates %s %d has the following error: \n  %s \n", TPM2ReturnCode, errorLocation, paramNumber, ErrorText1[errorCode] );
		}
	}
	
	return;
}






